/*
 * $Id: sid_.cxx,v 1.2 1996/04/02 18:25:58 ms Exp $
 *
 *
 * $Log: sid_.cxx,v $
 * Revision 1.2  1996/04/02 18:25:58  ms
 * Now copying the info buffer, to not modify its data
 *
 * Revision 1.1  1996/03/25 07:41:52  ms
 * Initial revision
 *
 */

#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <strstream.h>

#include <ctype.h>
#include <string.h>

#include "mytypes.h"
#include "m68k.h"
#include "fformat.h"
#include "sidtune.h"


const char text_sidformat[] = "Raw plus SIDPLAY ASCII text file (SID)";
const char text_sidchunkerror[] = "ERROR: Invalid chunk in description file";
const char text_sidnomemerror[] = "ERROR: Not enough memory";


int sidtune::SID_filesupport( void* databuffer, udword datalength,
							  void* sidbuffer, udword sidlength )
{
  char* sidbufcp = new char[sidlength];
  if ( sidbufcp == 0 )
	return(FALSE);
  memcpy( sidbufcp, sidbuffer, sidlength );
  int temp = SID_filesupport_grep( databuffer, datalength,
	  						       sidbufcp, sidlength );
  delete(sidbufcp);
  return(temp);
}


int sidtune::SID_filesupport_grep( void* databuffer, udword datalength,
							       char* sidbuffer, udword sidlength ) 
{
  char* sidbufcp = sidbuffer;
  
  istrstream sidin( sidbufcp, sidlength );
  if ( !sidin )  
	return(FALSE);
  
  if ( mystrncasecmp( sidbufcp, field_id1 ) != 0 )  
	return(FALSE);
  else  {
	if (( sidbufcp = returnnextline( sidbufcp )) == 0 )
	  return(FALSE);
	// no header in data file
	fileoffset = 0;
	// default = No
	musplayer = FALSE;
	numberofinfostrings = 0;
	
	int items = 0;
	udword restlen;
	char* thisline;
	while ( items < 6 )  {
	  if ( mystrncasecmp( sidbufcp, field_id3 ) == 0 )  {
		// ADDRESS
		restlen = sidlength - (udword)(sidbufcp - (char*)sidbuffer);
		istrstream addrin( sidbufcp +strlen(field_id3), restlen -strlen(field_id3) );
		if (( sidbufcp = returnnextline( thisline = sidbufcp )) == 0 )
		  return(FALSE);
		terminatethisline( thisline );
		if ( !addrin )  
		  return(FALSE);
		loadaddr = (uword)readhex( addrin );
		if ( !addrin )  
		  return(FALSE);
		initaddr = (uword)readhex( addrin );
		if ( !addrin )  
		  return(FALSE);
		playaddr = (uword)readhex( addrin );
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp, field_id4 ) == 0 )  {
		// SONGS
		restlen = sidlength - (udword)(sidbufcp - (char*)sidbuffer);
		istrstream numin( sidbufcp +strlen(field_id4), restlen -strlen(field_id4) );
		if (( sidbufcp = returnnextline( thisline = sidbufcp )) == 0 )
		  return(FALSE);
		terminatethisline( thisline );
		if ( !numin )  
		  return(FALSE);
		songs = (uword)readdec( numin );
		startsong = (uword)readdec( numin );
		if ( startsong == 0 )  
		  startsong++;
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp , field_id5 ) == 0 )
	  {
		// SPEED
		restlen = sidlength - (udword)(sidbufcp - (char*)sidbuffer);
		istrstream speedin( sidbufcp +strlen(field_id5), restlen -strlen(field_id5) );
		if (( sidbufcp = returnnextline( thisline = sidbufcp )) == 0 )
		  return(FALSE);
		terminatethisline( thisline );
		if ( !speedin )  
		  return(FALSE);
		speed = readhex( speedin );
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp , field_id6 ) == 0 )  {
		// NAME
		sidbufcp = returnnextline( thisline = sidbufcp );
		terminatethisline( thisline );
		strcpy( &infostring[0][0], thisline +strlen(field_id6) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp , field_id7 ) == 0 )  {
		// AUTHOR
		sidbufcp = returnnextline( thisline = sidbufcp );
		terminatethisline( thisline );
		strcpy( &infostring[1][0], thisline +strlen(field_id7) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp , field_id8 ) == 0 )  {
		// COPYRIGHT
		if (( sidbufcp = returnnextline( thisline = sidbufcp )) == 0 )
		  return(FALSE);
		terminatethisline( thisline );
		strcpy( &infostring[2][0], thisline +strlen(field_id8) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( sidbufcp , field_id9 ) == 0 )  {
		// SIDSONG=YES
		musplayer = TRUE;
		if (( sidbufcp = returnnextline( thisline = sidbufcp )) == 0 )
		  return(FALSE);
		terminatethisline( thisline );
		items++;
	  }
	  else  {
		formatstring = text_sidchunkerror;
		return( FALSE );
	  }
	};
	
	if (( loadaddr == 0 ) && ( datalength >= 2 ))  {
	  ubyte* databufcp = (ubyte*)databuffer;
	  loadaddr = m68k( *(databufcp +fileoffset +1), *(databufcp +fileoffset));
	  fileoffset += 2;
	}
	
	if ( initaddr == 0 )  
	  initaddr = loadaddr;
	
	formatstring = text_sidformat;
	return(TRUE);
  }
}
