/*
 * $Id: pp_.cxx,v 1.2 1996/02/27 07:33:44 ms Exp $
 *
 *
 * $Log: pp_.cxx,v $
 * Revision 1.2  1996/02/27 07:33:44  ms
 * No standard output anymore
 * Changes according to creation of class sidtune.cxx
 * Added extra procedure which returns length of uncompressed data
 *
 * Revision 1.1  1996/02/02 15:10:57  ms
 * Fixed #includes for FreeBSD; thanks to <aagero@aage.aage.priv.no>
 *
 * Revision 1.0  1996/01/21 04:12:50  ms
 * Initial revision
 *
 */

#include <fstream.h>
#include <string.h>

#include "mytypes.h"
#include "m68k.h"

#define DEPP_SYNTAX_ERROR 1
#define DEPP_OPENREAD_ERROR 2
#define DEPP_OPENWRITE_ERROR 3
#define DEPP_MEMORY_ERROR 4
#define DEPP_FORMAT_ERROR 5
//#define DEPP_RECURSIVE_ERROR 6

//#define DEPP_SAVETY_RANGE 2048

#define PP_ID "PP20"
//#define PP_EID "PX20"
#define PP_BITS_FAST 0x09090909
#define PP_BITS_MEDIOCRE 0x090a0a0a
#define PP_BITS_GOOD 0x090a0b0b
#define PP_BITS_VERYGOOD 0x090a0c0c
#define PP_BITS_BEST 0x090a0c0d


const char text_packeddatacorrupt[]	= "PowerPacker: Packed data is corrupt";
const char text_uncompressedtoolarge[] = "PowerPacker: Uncompressed data too large";
const char text_unrecognized[]	= "PowerPacker: Unrecognized compression method";
const char text_unknownformat[] = "Not compressed with PowerPacker";
const char text_fast[] = "PowerPacker: fast compression";
const char text_mediocre[] = "PowerPacker: mediocre compression";
const char text_good[] = "PowerPacker: good compression";
const char text_verygood[] = "PowerPacker: very good compression";
const char text_best[] = "PowerPacker: best compression";

const char* pperrorstring;

udword ppuncompressedlen(); // return the length of the uncompressed data

inline udword ppread( ifstream&, int);
void ppbytes( ifstream& );
void ppsequence( ifstream& );
void bytestodword( ifstream&, udword* );

ubyte* writeptr;
ubyte* startptr;
udword current;       // compressed data longword
int bits;             // number of bits in 'current' to evaluate
ubyte efficiency[4];
udword outputlen;
char globalerror;


int depp( ifstream& source, ubyte* dest, udword destmaxlen )
{
  pperrorstring = text_unknownformat;
  globalerror = FALSE;
  outputlen = 0;
  // check for header signature
  source.seekg( 0, ios::beg );
  char sig[5];
  source.read( sig, 4 );
  sig[4] = 0;
  if ( strcmp( sig, "PP20" ) != 0 )  return(FALSE);

  // now read in efficiency table
  source.read( efficiency, 4 );
  udword eff = m68k( efficiency[0], efficiency[1], efficiency[2], efficiency[3] );
  if (( eff != PP_BITS_FAST ) &&
	  ( eff != PP_BITS_MEDIOCRE ) &&
	  ( eff != PP_BITS_GOOD ) &&
	  ( eff != PP_BITS_VERYGOOD ) &&
	  ( eff != PP_BITS_BEST ))  
  {
	pperrorstring = text_unrecognized;
	return(-1);
  }

  // uncompressed length in bits 31-8 of last dword
  source.seekg( -4, ios::end );
  ubyte len[3];
  source.read( len, 3);
  outputlen = m68k( 0, len[0], len[1], len[2] );
  if ( outputlen > destmaxlen )
  {
	pperrorstring = text_uncompressedtoolarge;
	return(-1);
  }

  switch ( eff)
  {
   case PP_BITS_FAST:
	pperrorstring = text_fast;
	break;
   case PP_BITS_MEDIOCRE:
	pperrorstring = text_mediocre;
	break;
   case PP_BITS_GOOD:
	pperrorstring = text_good;
	break;
   case PP_BITS_VERYGOOD:
	pperrorstring = text_verygood;
	break;
   case PP_BITS_BEST:
	pperrorstring = text_best;
	break;
  }
  
  // put destptr to end of uncompressed data
  startptr = dest;
  writeptr = dest + outputlen;

  // read number of unused bits in 1st data dword
  // from lowest bits 7-0 of last dword
  char bitb;
  source.get( bitb );
  bits = 32 - bitb;

  // decompress data
  source.seekg( 0, ios::end );
  udword inputlen = source.tellg();
  source.seekg( inputlen -4, ios::beg );
  bytestodword( source, &current );
  if ( bits != 32 )  current = ( current >> ( 32 - bits ));

  do
  {
	if ( ppread( source, 1) == 0 )  
	  ppbytes( source );
	if ( writeptr > dest )  
	  ppsequence( source );
	if ( globalerror )
	  return(-1);
  } while ( writeptr > dest );

  //
  source.seekg( 0, ios::beg );
  return(TRUE);
}


udword ppuncompressedlen()
{
  return(outputlen);
}

//
inline udword ppread( ifstream& source, int count)
{
  udword data = 0;
  // read 'count' bits of packed data
  for ( ; count > 0; count-- )
  {
	// equal to shift left
	data += data;
	// merge bit 0
    data = ( data | (current & 1) );
    current = ( current >> 1 );
    if ( (--bits) == 0 )
    {
      bytestodword( source, &current );
      bits = 32;
    }
  }
  return (data);
}

//
void ppbytes( ifstream& source )
{
  udword count, add;
  count = ( add = ppread( source, 2 ) );
  while ( add == 3 )
  {
	add = ppread( source, 2);
	count += add;
  }
  count++;
  if ( writeptr > startptr )
  {
	for ( ; count > 0 ; count-- )  *(--writeptr) = (ubyte)ppread( source, 8 );
  }
}

//
void ppsequence( ifstream& source )
{
  udword offset, length, add;
  int offsetbitlen;
  length = ppread( source, 2);       // length -2
  offsetbitlen = (int)efficiency[length];
  length += 2;
  if ( length != 5 )
  {
	offset = ppread( source, offsetbitlen );
  }
  else
  {
	if ( ppread( source, 1) == 0 )   offsetbitlen = 7;
	offset = ppread( source, offsetbitlen);
	add = ppread( source, 3);
	length += add;
	while ( add == 7 )
	{
	  add = ppread( source, 3);
	  length += add;
	}
  }
  if ( writeptr > startptr )
  {
	for ( ; length > 0 ; length-- )   *(--writeptr) = *(writeptr + 1 + offset);
  }
}

// moves four bytes to Motorola big-endian double-word
void bytestodword( ifstream& source, udword* data)
{
  source.seekg( -4, ios::cur );
  ubyte mdat[4];
  source.read( mdat, 4 );
  *data = m68k( mdat[0], mdat[1], mdat[2], mdat[3] );
  source.seekg( -4, ios::cur );
  if ( source.bad() )
  {
	pperrorstring = text_packeddatacorrupt;
	globalerror = TRUE;
  }
}
