/*
 * $Id: speed.c,v 1.1 1996/02/28 00:04:47 ms Exp $
 *
 *
 * $Log: speed.c,v $
 * Revision 1.1  1996/02/28 00:04:47  ms
 * Fixed selection of pal/force_ntsc/timer speed
 *
 * Revision 1.0  1996/01/21 04:12:05  ms
 * Initial revision
 *
 */

#include "mytypes.h"

/*
 * 985248, 4025h (PAL) 
 * 1022727, 4295h (NTSC) 
 *
 * speed = 0 : 50 Hz 
 *       = 1 : 60 Hz bzw. CIA-Timer A 
 * 
 * mode = 0 : PAL
 *      = 1 : NTSC
 */

extern ubyte* c64mem2;

extern uword PCMfreq;

extern udword SAMPLESadd;
extern udword SAMPLEScomma;
extern uword SAMPLES;


udword takt;
uword deftimer, timer; 


void sidsetreplayingspeed(speed, mode)
byte speed, mode;
{
  uword calls = 50;
  switch ( speed | mode)
  { 
    default:
    case 0:      
    /* PAL */
      takt = 985248;
      timer = ( deftimer = 0x4025 );
      break;
    case 1:
      /* NTSC */
      takt = 1022727;
      timer = ( deftimer = 0x4295 );
      break;
  }
  if ( speed | mode )
  {
    timer = (( c64mem2[0xdc05] << 8 ) + c64mem2[0xdc04] );
    if ( timer < 16 )  timer = deftimer;
    calls = takt / timer;
  }
  SAMPLES = PCMfreq / calls;                              
  SAMPLEScomma = (( PCMfreq % calls ) * 65536 ) / calls;  
  SAMPLESadd = 0; 
}



void sidchangereplayingspeed()
{ 
  uword calls;
  if ( timer != (( c64mem2[0xdc05] << 8 ) + c64mem2[0xdc04] ))
  {
    timer = (( c64mem2[0xdc05] << 8 ) + c64mem2[0xdc04] );
    if ( timer < 16 )  timer = deftimer;
    calls = takt / timer;
    SAMPLES = PCMfreq / calls;                              
    SAMPLEScomma = (( PCMfreq % calls ) * 65536 ) / calls;  
    SAMPLESadd = 0;
  }
}
