#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>

#include <sys/ioctl.h>
#ifdef linux
 #include <linux/soundcard.h>
#elif defined(__FreeBSD__)
 #include <machine/soundcard.h>
#elif defined(sun) && defined(sparc)
 #include <sun/audioio.h>
 //#include <sun/dbriio.h>
#elif define (sgi)
 #include <errno.h>
 #include <audio.h>
 #include <dmedia/audio.h>
#endif

#include "mytypes.h"
#include "sidtune.h"
#include "6581.h"

extern "C" {
 #include "forms.h"
 #include "gui.h"
}
#include "list.h"
#include <string.h>




// before compiling the RCS distribution, consider doing
// a 'co -kv sidplay.cxx' to substitute the keyword string
#define version "1.7"
#if defined(linux) || defined(__FreeBSD__) 
 #define AUDIO "/dev/dsp"
#elif defined(sun) && defined(sparc)
 #define AUDIO "/dev/audio"
#endif

#define TXT_TITLE 1
#define ERR_NOT_ENOUGH_MEMORY 4
#define ERR_SYNTAX 5
#define ERR_IOCTL 6


#define FLAG_PLAYSID 1
#define FLAG_FORCENTSC 2

byte globalflags = 0;


void error( char*, char* );
void printtext( int );

ubyte* samplebufferptr;


sidtune *mysid=NULL;

sidemuconfig sidcfg;




/*****************************************************************/
/*                 GUI Stuff                                     */
/*****************************************************************/


// bitmaps for some of the buttons

#define stop_width 10
#define stop_height 9
static unsigned char stop_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,
  0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define play_width 10
#define play_height 9
static unsigned char play_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3c, 0x00, 0xfc, 0x00, 0x3c, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define pause_width 10
#define pause_height 9
static unsigned char pause_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0xcc, 0x00, 0xcc, 0x00, 0xcc, 0x00,
  0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define nextsong_width 10
#define nextsong_height 9
static unsigned char nextsong_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0xa4, 0x00, 0xec, 0x00, 0xfc, 0x00, 0xec, 0x00,
  0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define prevsong_width 10
#define prevsong_height 9
static unsigned char prevsong_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x94, 0x00, 0xdc, 0x00, 0xfc, 0x00, 0xdc, 0x00,
  0x94, 0x00, 0x00, 0x00, 0x00, 0x00, };

FD_SIDPlay *gui;
char *filename;
#define NOBUTTONS 0
#define PLAY  1
#define STOP  2
#define PAUSE 4
#define PREVSONG  8
#define NEXTSONG  16
#define REMOVE 32
#define NEXT 64
unsigned int buttons_active;

void SetActiveButtons(unsigned int active){
  if (active&PLAY){fl_activate_object(gui->play); fl_set_object_color(gui->play,FL_BITMAPBUTTON_COL1,FL_BITMAPBUTTON_COL2);}
  else{fl_deactivate_object(gui->play);fl_set_object_color(gui->play,FL_INACTIVE_COL,FL_BITMAPBUTTON_COL2);}
  if (active&STOP){fl_activate_object(gui->stop); fl_set_object_color(gui->stop,FL_BITMAPBUTTON_COL1,FL_BITMAPBUTTON_COL2);}
  else{fl_deactivate_object(gui->stop);fl_set_object_color(gui->stop,FL_INACTIVE_COL,FL_BITMAPBUTTON_COL2);}
  if (active&PAUSE){fl_activate_object(gui->pause); fl_set_object_color(gui->pause,FL_BITMAPBUTTON_COL1,FL_BITMAPBUTTON_COL2);}
  else{fl_deactivate_object(gui->pause);fl_set_object_color(gui->pause,FL_INACTIVE_COL,FL_BITMAPBUTTON_COL2);}
  if (active&PREVSONG){fl_activate_object(gui->prevsong); fl_set_object_color(gui->prevsong,FL_BITMAPBUTTON_COL1,FL_BITMAPBUTTON_COL2);}
  else{fl_deactivate_object(gui->prevsong);fl_set_object_color(gui->prevsong,FL_INACTIVE_COL,FL_BITMAPBUTTON_COL2);}
  if (active&NEXTSONG){fl_activate_object(gui->nextsong); fl_set_object_color(gui->nextsong,FL_BITMAPBUTTON_COL1,FL_BITMAPBUTTON_COL2);}
  else{fl_deactivate_object(gui->nextsong);fl_set_object_color(gui->nextsong,FL_INACTIVE_COL,FL_BITMAPBUTTON_COL2);}
  if (active&NEXT){fl_activate_object(gui->next); fl_set_object_color(gui->next,FL_BUTTON_COL1,FL_BUTTON_COL2);}
  else{fl_deactivate_object(gui->next);fl_set_object_color(gui->next,FL_INACTIVE_COL,FL_BUTTON_COL2);}
  if (active&REMOVE){fl_activate_object(gui->remove);fl_set_object_color(gui->remove,FL_BUTTON_COL1,FL_BUTTON_COL2);}
  else{fl_deactivate_object(gui->remove);fl_set_object_color(gui->remove,FL_INACTIVE_COL,FL_BUTTON_COL2);}
  buttons_active=active;
}

List<char *>  playlist;

void PatchGUI(){
  fl_set_bitmapbutton_data(gui->play,play_width,play_height,play_bits);
  fl_set_bitmapbutton_data(gui->stop,stop_width,stop_height,stop_bits);
  fl_set_bitmapbutton_data(gui->pause,pause_width,pause_height,pause_bits);
  fl_set_bitmapbutton_data(gui->nextsong,nextsong_width,nextsong_height,nextsong_bits);
  fl_set_bitmapbutton_data(gui->prevsong,prevsong_width,prevsong_height,prevsong_bits);
}

char *BaseNameOfFilename(char *s){
  
  int count=0,last_slash_pos=-1;
  while(s[count]!='\0'){
    if(s[count]=='/')
      last_slash_pos=count;
    count++;
  }
  return &s[last_slash_pos+1];
}




void PlaylistAdd(FL_OBJECT *fl_obj, long data){
  char *filename;
  
  filename=fl_show_fselector("Load",getenv("SIDSONGPATH"),"*","");
  if (filename!=NULL){
    char *tmpstring=(char *)malloc(strlen(filename)+1);
    strcpy(tmpstring,filename);
    //tmpstring[strlen(filename)]='\0';
    playlist.GotoEnd();
    playlist.Insert(tmpstring);
    fl_addto_browser(gui->playlist,BaseNameOfFilename(tmpstring));
    
    //playlist.Print();
  }
}

void PlaylistRemove(FL_OBJECT *fl_obj, long data){
  int line=fl_get_browser(gui->playlist);
  if(line!=0){
    fl_delete_browser_line(gui->playlist,line);
    playlist.GotoIndex(line-1);
    playlist.Delete();
    
    SetActiveButtons(buttons_active&(PLAY|STOP|PREVSONG|NEXTSONG|PAUSE));
    
    //playlist.Print();
  }
}


#define STOPPED 0
#define PLAYING 1
#define PAUSED 2
int player_state=STOPPED;

void Stop(FL_OBJECT *fl_obj,long data){
  if (player_state==PLAYING || player_state==PAUSED)
    player_state=STOPPED;
  
  SetActiveButtons(buttons_active&(NEXT|REMOVE)|PLAY);
  if (mysid->returncurrentsong()>1) SetActiveButtons(buttons_active|PREVSONG);
  if (mysid->returncurrentsong()<mysid->returnnumberofsongs()) SetActiveButtons(buttons_active|NEXTSONG);
  if (data==0){
    mysid->initializesong(mysid->returncurrentsong());
  }
}
char *my_itoa(unsigned int i,char *str){
  unsigned int ten=100;
  int j=0;
  while(ten>0){
    if(i/ten == 0 && j==0);
    else{
      str[j++]=(i/ten)+'0';
      i=i-(i/ten)*ten;
    }
    ten=ten/10;
  }
  if (j==0) str[j++]='0';
  str[j]=0;
  return str;
}

char *SongOfSongs(int songnr,int songs,char *str){
  my_itoa(songnr,str);
  int sl=strlen(str);
  str[sl]='/';
  my_itoa(songs,str+sl+1);
  return str;
}

void Play(FL_OBJECT *fl_obj, long data){
  // if this is a new song or it was stopped then load it and init player
  //mysid->initializesong(mysid->returncurrentsong());
  SetActiveButtons(buttons_active&(NEXT|REMOVE)|STOP|PAUSE);
  
  if (mysid->returncurrentsong()>1) SetActiveButtons(buttons_active|PREVSONG);
  if (mysid->returncurrentsong()<mysid->returnnumberofsongs()) SetActiveButtons(buttons_active|NEXTSONG);
  
  player_state=PLAYING;
}

void PrevSong(FL_OBJECT *fl_obj, long data){
  mysid->initializesong(mysid->returncurrentsong()-1);
  
  fl_addto_form(gui->SIDPlay);
  fl_delete_object(gui->song);
  fl_free_object(gui->song);
  char sos[10];
  gui->song = fl_add_box(FL_DOWN_BOX,280,116,254,22,SongOfSongs(mysid->returncurrentsong(),mysid->returnnumberofsongs(),sos));
  fl_set_object_color(gui->song,FL_MCOL,FL_COL1);
  fl_end_form();
  
  SetActiveButtons(buttons_active&(PLAY|STOP|PAUSE|NEXT|REMOVE));
  if (mysid->returncurrentsong()>1) SetActiveButtons(buttons_active|PREVSONG);
  if (mysid->returncurrentsong()<mysid->returnnumberofsongs()) SetActiveButtons(buttons_active|NEXTSONG);
}

void NextSong(FL_OBJECT *fl_obj, long data){
  mysid->initializesong(mysid->returncurrentsong()+1);
  fl_addto_form(gui->SIDPlay);
  fl_delete_object(gui->song);
  fl_free_object(gui->song);
  char sos[10];
  gui->song = fl_add_box(FL_DOWN_BOX,280,116,254,22,SongOfSongs(mysid->returncurrentsong(),mysid->returnnumberofsongs(),sos));
  fl_set_object_color(gui->song,FL_MCOL,FL_COL1);
  fl_end_form();
  
  SetActiveButtons(buttons_active&(PLAY|STOP|PAUSE|NEXT|REMOVE));
  if (mysid->returncurrentsong()>1) SetActiveButtons(buttons_active|PREVSONG);
  if (mysid->returncurrentsong()<mysid->returnnumberofsongs()) SetActiveButtons(buttons_active|NEXTSONG);
}

void Pause(FL_OBJECT *fl_obj, long data){
   player_state=PAUSED;
   SetActiveButtons(buttons_active&(NEXT|REMOVE)|PLAY|STOP);
 }

void SelectSong(FL_OBJECT *fl_obj,long data){
   //Stop(NULL,1);
  int selected=fl_get_browser(fl_obj);
  if(selected!=0){
    playlist.GotoIndex(selected-1);
    filename=playlist.Get();
  }
  char sos[10]="";
  // delete old sidtune
  if (mysid!=NULL)
    delete mysid;
  // load new sidtune
  mysid=new sidtune(filename);
  // handle errors
  if (!*mysid) {
    fl_show_message(mysid->returnstatusstring(),"The song will be removed from the list.",""); 
    PlaylistRemove(gui->remove,0);

    SetActiveButtons(NOBUTTONS);
    player_state=STOPPED;
  }
  else{
	if ( globalflags & FLAG_PLAYSID )
	  mysid->setplaysidflag( TRUE );
	if ( globalflags & FLAG_FORCENTSC )
	  mysid->setforcentsc( TRUE );
    mysid->initializesong(mysid->returnstartsong());
    SongOfSongs(mysid->returncurrentsong(),mysid->returnnumberofsongs(),sos);
    
    if (player_state==PAUSED || player_state==STOPPED){
      player_state=STOPPED;
      SetActiveButtons(REMOVE|NEXT|PLAY);
    }
    else
      SetActiveButtons((buttons_active&(PLAY|STOP|PAUSE))|REMOVE|NEXT);
    if (mysid->returncurrentsong()>1) SetActiveButtons(buttons_active|PREVSONG);
    if (mysid->returncurrentsong()<mysid->returnnumberofsongs()) SetActiveButtons(buttons_active|NEXTSONG);
  }
  // update display
  fl_addto_form(gui->SIDPlay);
  fl_delete_object(gui->title);
  fl_delete_object(gui->author);
  fl_delete_object(gui->copyright);
  fl_delete_object(gui->song);
  fl_free_object(gui->title);
  fl_free_object(gui->author);
  fl_free_object(gui->copyright);
  fl_free_object(gui->song);
  gui->title=fl_add_box(FL_DOWN_BOX,280,208,254,22,mysid->returnnameinfo());
  gui->author = fl_add_box(FL_DOWN_BOX,280,176,254,22,mysid->returnauthorinfo());
  gui->copyright = fl_add_box(FL_DOWN_BOX,280,146,254,22,mysid->returncopyrightinfo());
  gui->song = fl_add_box(FL_DOWN_BOX,280,116,254,22,sos);
  fl_set_object_color(gui->song,FL_MCOL,FL_COL1);
  
  fl_set_object_color(gui->author,FL_MCOL,FL_COL1);
  fl_set_object_color(gui->copyright,FL_MCOL,FL_COL1);
  fl_set_object_color(gui->title,FL_MCOL,FL_COL1);
  
  fl_end_form();
  
}

void NextInList(FL_OBJECT *fl_obj,long data){
  int current=fl_get_browser(gui->playlist);
  int max=fl_get_browser_maxline(gui->playlist);
  if (max==0 || current==0) return;
  if (current<max){
    fl_select_browser_line(gui->playlist,current+1);
  }
  else{
    fl_select_browser_line(gui->playlist,1);
  }
  SelectSong(gui->playlist,0);
}





/*****************************************************************/


int main(int argc, char *argv[])
{
  // title
  printtext(TXT_TITLE);
  
  //
  ubyte infile = 0;
  
  // defaults
  udword frequency = 22050;
  uword channels = SIDEMU_MONO;
  
  uword fragments = 2;
  uword fragsizebase = 10;
  
  // parse command line arguments
  for ( int a = 1; a < argc; a++)  
  {
    if ( argv[a][0] == '-')  
      {
	// reading from stdin
	if ( strlen(argv[a]) == 1 )
	  {	
	    if ( infile == 0 )
	      {
			infile = a;
			break;
	      }
	    else 
		  printtext(ERR_SYNTAX);
	  }
	switch ( argv[a][1] )
	  {
	  case 'a':
	    globalflags |= FLAG_PLAYSID;
	    break;
	  case 'b':
	    if ( argv[a][2] == 'n' )  
	      {
		fragments = (unsigned)atoi(argv[a]+3);
		if (( fragments < 2 ) || ( fragments > 255 )) fragments = 2;
	      }
	    else if ( argv[a][2] == 's' )  
	      {
		fragsizebase = (unsigned)atoi(argv[a]+3);
		if (( fragsizebase < 7 ) || ( fragsizebase > 17 )) fragsizebase = 14;
	      }
	    break;
	  case 'f':
	    frequency = (udword)atol(argv[a]+2);
	    break;
	  case 'h':
	    printtext(ERR_SYNTAX);
	    break;
	  case 'n':
		globalflags |= FLAG_FORCENTSC;
		break;
	  default:
	    printtext(ERR_SYNTAX);
	    break;
	  }
      }
    else  
      {
	// filename argument
	if ( infile == 0 )  infile = a;
	else printtext(ERR_SYNTAX);
      }
  }

// --- Begin of VoxWare dependent initialization part ---
  
#if defined(linux) || defined(__FreeBSD__)
  int audiohd = open(AUDIO, O_WRONLY, 0);
  if ( audiohd == -1 )
    { 
      cerr << "ERROR: Cannot open audio device " << AUDIO << endl;
      exit (-1);
    }
  
  int dsp_samplesize = 8;
  if ( ioctl(audiohd, SNDCTL_DSP_SAMPLESIZE, &dsp_samplesize) == -1 )  printtext(ERR_IOCTL);
  
  int dsp_stereo = 0;
  if ( ioctl(audiohd, SNDCTL_DSP_STEREO, &dsp_stereo ) == -1 )  printtext(ERR_IOCTL);
  
  int dsp_speed = frequency;
  if ( ioctl(audiohd, SNDCTL_DSP_SPEED, &dsp_speed ) == -1 )  printtext(ERR_IOCTL);
  
  // N fragments of size (2 ^ S) bytes
  //              NNNNSSSS
  // int frag = 0x0004000e;
  int frag = ( fragments << 16 ) + fragsizebase;
  ioctl(audiohd, SNDCTL_DSP_SETFRAGMENT, &frag);
  
  int frag_size;
  ioctl(audiohd, SNDCTL_DSP_GETBLKSIZE, &frag_size);
  cout << "Buffers      : " << fragments 
	   << "\nBuffersize   : " << (udword)(1 << fragsizebase) << "\n";
  
  if (( samplebufferptr = new ubyte[frag_size]) == 0 )  printtext(ERR_NOT_ENOUGH_MEMORY);
  
  // --- SunOS 4.1.4 with dbri driver dependent part ---
#elif defined(sparc) && defined(sun)
  
  int audiohd = open(AUDIO, O_WRONLY, 0);
  if ( audiohd == -1 )
    { 
      cerr << "ERROR: Cannot open audio device " << AUDIO << endl;
    exit (-1);
    }
  int hwdevice;
  if ( ioctl( audiohd, AUDIO_GETDEV, &hwdevice ) == (-1))  printtext( ERR_IOCTL );
  if ( hwdevice != AUDIO_DEV_SPEAKERBOX )
    {
    cerr << "ERROR: Speakerbox not enabled" << endl;
    exit(-1);
  }
  
  // choose the nearest possible frequency
  uword dbrifreqs[] = 
    {
      8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000, 0
      };
  int dbrifsel = 0;
  int dbrifreqdiff = 100000;
  int dbrifrequency = frequency;
  do
    {  
      int dbrifreqdiff2 = frequency - dbrifreqs[dbrifsel];
      dbrifreqdiff2 < 0 ? dbrifreqdiff2 = 0 - dbrifreqdiff2 : dbrifreqdiff2 += 0;
      if ( dbrifreqdiff2 < dbrifreqdiff )  
	{
	  dbrifreqdiff = dbrifreqdiff2;
	  dbrifrequency = dbrifreqs[dbrifsel];
	}
      dbrifsel++;
  }  while ( dbrifreqs[dbrifsel] != 0 );
  frequency = dbrifrequency;
  
  int dsp_samplesize = 16;
  
  audio_info myaudio_info;
  if ( ioctl( audiohd, AUDIO_GETINFO, &myaudio_info ) == (-1))  printtext(ERR_IOCTL);
  AUDIO_INITINFO( &myaudio_info );
  myaudio_info.play.sample_rate = frequency;
  if ( channels == SIDEMU_MONO )  myaudio_info.play.channels = 1;
  else if ( channels == SIDEMU_STEREO )  myaudio_info.play.channels = 2;
  myaudio_info.play.precision = dsp_samplesize;
  myaudio_info.play.encoding = AUDIO_ENCODING_LINEAR;
  myaudio_info.output_muted = 0;
  if ( ioctl( audiohd, AUDIO_SETINFO, &myaudio_info ) == (-1))  printtext(ERR_IOCTL);
  
  int bufsize = frequency;
  if (( samplebufferptr = new ubyte[bufsize]) == 0 )  printtext(ERR_NOT_ENOUGH_MEMORY);
  
  // --- Silicon Graphics dependent part
  
#elif defined(sgi)
  ALport audio;
  ALconfig config;
  
  long chpars[] = {AL_OUTPUT_RATE, 0};
  
  // Frequency
  
  chpars[1] = frequency;
  ALsetparams(AL_DEFAULT_DEVICE, chpars, 2);
  ALgetparams(AL_DEFAULT_DEVICE, chpars, 2);
  config = ALnewconfig();
 
  // Set sample format
  
  ALsetsampfmt(config, AL_SAMPFMT_TWOSCOMP);
  
  // Mono output
  
  ALsetchannels(config, AL_MONO);
  
  // 8-bit samplesize
 
  ALsetwidth(config, AL_SAMPLE_8);
  
  // Allocate an audio port
  
  if((audio = ALopenport("SIDPLAY sound", "w", config)) == NULL) {
    oserror();
    exit(1);
  }
  
  // Allocate sound buffers
  int bufsize = frequency;
  ALsetqueuesize(config, bufsize);
  
  if (( samplebufferptr = new ubyte[bufsize]) == 0 )  printtext(ERR_NOT_ENOUGH_MEMORY);
#endif /* SGI part */
  
  cout << "Frequency    : " << dec << sidcfg.setfrequency( frequency ) << " Hz" << endl;
  if ( dsp_samplesize != sidcfg.setbitspersample( dsp_samplesize ))
    {
      cerr << "SIDEMU: Not capable of requested sample precision" << endl;
      exit(-1);
    }
#if defined(linux) || defined(__FreeBSD__)
  if ( SIDEMU_UNSIGNED_PCM != sidcfg.setsampleformat( SIDEMU_UNSIGNED_PCM ))
#elif defined(sun) && defined(sparc)
    if ( SIDEMU_SIGNED_PCM != sidcfg.setsampleformat( SIDEMU_SIGNED_PCM ))
#elif defined(sgi)
      if ( SIDEMU_SIGNED_PCM != sidcfg.setsampleformat( SIDEMU_SIGNED_PCM ))
#else
#error Have to set sampleformat 
#endif	
	{
	  cerr << "SIDEMU: Not capable of requested sample encoding" << endl;
	  exit(-1);
	}
#if defined(linux) || defined(__FreeBSD__)
  //if ( SIDEMU_STEREO != sidcfg.setchannels( SIDEMU_STEREO ))
  //{
  //	cerr << "SIDEMU: Not capable of requested number of channels" << endl;
  //  exit(-1);
  //}
#endif	
  if ( sidemuinit( sidcfg ) == FALSE )  
    {
      cerr << "SIDEMU: Unable to allocate enough memory" << endl;
      exit(-1);
    }
  sidemureset( sidcfg );
  
  // start the GUI
  fl_initialize(argv[0],"SIDPLAY",0,0,&argc,argv);
  gui=create_form_SIDPlay();
  PatchGUI();
  fl_show_form(gui->SIDPlay,FL_PLACE_GEOMETRY,FL_FULLBORDER,"SIDPLAY 1.7");
  SetActiveButtons(NOBUTTONS);
  
  

  //  mysid->initializesong(mysid->returncurrentsong());
  
  

  //cout << "Playing, press ^C to stop ...\n" << flush;
  while(1){
    while(player_state==STOPPED || player_state==PAUSED)
      fl_check_forms();
    while ( player_state==PLAYING )
      {
	fl_check_forms();
	if(player_state==STOPPED || player_state==PAUSED) break;
	
#if defined(linux) || defined(__FreeBSD__)
	sidemufillbuffer( sidcfg, *mysid, samplebufferptr, frag_size );
	write( audiohd, samplebufferptr, frag_size );
#elif defined(sparc) && defined(sun)
	sidemufillbuffer( sidcfg, *mysid, samplebufferptr, bufsize );
	write( audiohd, samplebufferptr, bufsize );
#elif defined(sgi)
	sidemufillbuffer( sidcfg, *mysid, samplebufferptr, bufsize );
	ALwritesamps( audio, samplebufferptr, bufsize );
#endif	
      }
  }
  
  // will possibly never come this far  
#if defined(linux) || defined(__FreeBSD__)
  close(audiohd);
#elif defined(sparc) && defined(sun)
  close(audiohd);
#elif defined(sgi)
  ALcloseport(audio);
  ALfreeconfig(config);
#endif
  delete(samplebufferptr);
  return(0);
}


void error(char* s1, char* s2 = "")
{
  cerr << "ERROR: " << s1 << ' ' << "'" << s2 << "'\n";
  exit(-1);
}


void printtext(int number)
{
  switch (number)  
  {
   case TXT_TITLE:
#ifdef __FreeBSD__
	  cout << endl << "SIDPLAY/FreeBSD";
#elif defined(linux)
	  cout << endl << "SIDPLAY/Linux";
#elif defined(sun)
	  cout << endl << "SIDPLAY/SunOS";
#elif defined(sgi)
	  cout << endl << "SIDPLAY/SGI";
#else
	  cout << endl << "SIDPLAY";
#endif	  
	  cout << "   Music player and C64 SID chip emulator   Version " << version << endl
	       << "Copyright (c) 1995,1996 Michael Schwendt   All rights reserved." << endl
           << "Internet e-mail: 3schwend@informatik.uni-hamburg.de" << endl;
#if defined(sgi)
	  cout << "Ported by <aagero@aage.aage.priv.no>" << endl;
#else 
	  cout << endl;
#endif	
	  cout << "GUI by Brian Nielsen <norman@iesd.auc.dk>" << endl << endl;
	  break;
    case ERR_NOT_ENOUGH_MEMORY:
	  cerr << "ERROR: Not enough memory\n";
      exit(-1);
    case ERR_SYNTAX:
      cout << " Syntax: SIDGUI [-<commands>]\n"
           << " commands: -h       display this screen\n"
           << "           -f<num>  set frequency in Hz (default: 22050)\n"
           << "           -a       improve PlaySID compatibility (read the docs !)\n"
           << "           -bn<num> set number of audio buffers to use\n"
           << "           -bs<num> set size 2^<num> of audio buffers\n\n";
      exit(-1);
    case ERR_IOCTL:
      cerr << "IOCTL: Could not set up sound device properly\n";
      exit(-1);
    default:
      cerr << "ERROR: Internal system error\n";
      exit(-1);
  }
}



