/*
 * $Id: config.cxx,v 1.5 1996/04/02 14:55:59 ms Exp $
 *
 *
 * $Log: config.cxx,v $
 * Revision 1.5  1996/04/02 14:55:59  ms
 * Applied some Windows-specific patches
 *
 * Revision 1.4  1996/03/01 16:18:50  ms
 * Changes in interface to samples.cxx
 *
 * Revision 1.3  1996/02/27 08:57:23  ms
 * Added destructor that frees sidemu memory
 * Added possibility to check for a sane status of the sidemu
 *
 * Revision 1.2  1996/02/20 19:24:42  ms
 * Changes to 8/16-bit and stereo support
 *
 * Revision 1.1.1.1  1996/02/17 23:08:41  ms
 * Fixed reset of 16-bit and stereo fillroutines
 *
 * Revision 1.1  1996/02/16 01:03:59  ms
 * Initial revision
 *
 */
#if defined(_Windows) && !defined(__WIN32__)
  #include <windows.h>
  #include <windowsx.h>
#endif

#include "mytypes.h"
#include "6581.h"
#include "opstruct.h"
#include "samples.h"


extern uword PCMfreq;
extern udword PCMsid, PCMnoisesid;
extern udword tofill;
extern ubyte bufferscale;

extern ubyte zero8bit;
extern uword zero16bit;

extern ubyte sidkeys[];

extern ubyte* DreieckTable;
extern ubyte* SaegezahnTable;
extern ubyte* RechteckTable;
extern ubyte* RauschenTable;
extern byte* AmplModTable;

extern ubyte RMbegrenzer[512];

extern void enveemuinit( udword );


sidemuconfig::~sidemuconfig()
{
  sidemufreemem();
}


uword sidemuconfig::setfrequency( uword f )
{
  if (( f >= 4000 ) && ( f <= 48000 ))  frequency = f;
  return( frequency );
}

  
uword sidemuconfig::setbitspersample( uword n )
{
  if (( n == SIDEMU_8BIT ) || ( n == SIDEMU_16BIT ))  bitspersample = n;
  return( bitspersample );
}


uword sidemuconfig::setsampleformat( uword x )
{
  if (( x == SIDEMU_UNSIGNED_PCM ) ||
	  ( x == SIDEMU_SIGNED_PCM ))  sampleformat = x;
  return( sampleformat );
}


uword sidemuconfig::setchannels( uword n )
{
  if (( n == SIDEMU_MONO ) || 
	  ( n == SIDEMU_STEREO ))  channels = n;
  return( channels );
}


uword sidemuconfig::setsidchips( uword n )
{
  if ( n == 1 )  sidchips = n;
  return( sidchips );
}


int sidemufreemem()
{
  if ( DreieckTable != 0 )
  {
    delete( DreieckTable );
	DreieckTable = 0;
  }
  if ( SaegezahnTable != 0 )
  {
    delete( SaegezahnTable );
	SaegezahnTable = 0;
  }
  if ( RechteckTable != 0 )
  {
    delete( RechteckTable );
	RechteckTable = 0;
  }
  if ( RauschenTable != 0 )
  {
    delete( RauschenTable );
	RauschenTable = 0;
  }
  if ( AmplModTable != 0 )
  {
#if defined(_Windows) && !defined(__WIN32__)
    GlobalFreePtr ( AmplModTable );
#else
    delete( AmplModTable );
#endif
	AmplModTable = 0;
  }
  return(TRUE);
}


// must be TRUE to allow successful reset
int initflag = FALSE;

int sidemuinit( sidemuconfig& sidcfg )
{
  initflag = FALSE;
  
  sidemufreemem();
#if defined(_Windows) && !defined(__WIN32__)
  if (( AmplModTable = (byte *)GlobalAllocPtr (GPTR, 65536L) ) == 0 )
    return(FALSE);
#else
  if (( AmplModTable = new byte[256*256] ) == 0 )  return(FALSE);
#endif
  if (( DreieckTable = new ubyte[4096] ) == 0 )  return(FALSE);
  if (( SaegezahnTable = new ubyte[4096] ) == 0 )  return(FALSE);
  if (( RechteckTable = new ubyte[2*4096] ) == 0 )  return(FALSE);
  if (( RauschenTable = new ubyte[4*4096] ) == 0 )  return(FALSE);
    
  PCMfreq = sidcfg.frequency;
  PCMsid = ( (udword)PCMfreq * 69748 ) / 4096;
  PCMnoisesid = 40017 * PCMfreq / 22050;

  int i,j,k;
  word si, sj;
  uword uk;
  
  k = 0;
  for ( i = 0; i < 128; i++ )  RMbegrenzer[k++] = 128;
  for ( i = 0; i < 256; i++ )  RMbegrenzer[k++] = 128 +i;
  for ( i = 0; i < 128; i++ )  RMbegrenzer[k++] = 127;

  k = 0;
  for ( i = 0; i < 256; i++ )
  {
    for ( j = 0; j < 8; j++ )  DreieckTable[k++] = 128 +i;
  }
  for ( i = 0; i < 256; i++ )
  {
    for ( j = 0; j < 8; j++ )  DreieckTable[k++] = (255 -i) -128;
  }
  
  k = 0;
  for ( i = 0; i < 256; i++ )
  {
    for ( j = 0; j < 16; j++ )  SaegezahnTable[k++] = 128 +i;
  }

  k = 0;
  for ( i = 0; i < 4096; i++ )  RechteckTable[k++] = 127;
  for ( i = 0; i < 4096; i++ )  RechteckTable[k++] = 128;

  const dword a = 16807,
              m = 2147483647,
              q = (m / a),
              r = (m % a);
  dword z, z2, temp;
  z = 30031972;
  for ( i = 0; i < 16384; i++ )
  {
    z2 = a * (z % q);
    temp = z2 - r * (z / q);
    if ( temp < 0 )  temp += m;
    z = temp;
    RauschenTable[i] = (temp >> (32-8-1)) -128;
  }

  uk = 0;
  for ( si = 0; si < 256; si++ )
  {
    for ( sj = 0; sj < 128; sj++ )
    {
	  if ( sidcfg.channels == SIDEMU_STEREO )
        AmplModTable[uk++] = ( ( si * sj ) /255) /2;
      else  AmplModTable[uk++] = ( ( si * sj ) /255) /4;
    }
    for ( sj = -128; sj < 0; sj++ )
    {
	  if ( sidcfg.channels == SIDEMU_STEREO )
        AmplModTable[uk++] = ( ( si * sj ) /255) /2;
      else  AmplModTable[uk++] = ( ( si * sj ) /255) /4;
    }
  }
  
  samplesemuinit();
  enveemuinit( PCMfreq );
  initflag = TRUE; // will allow reset
  sidemureset( sidcfg );
  
  return(TRUE);
}


int sidemureset( sidemuconfig& sidcfg )
{
  extern sidoperator optr1;
  extern sidoperator optr2;
  extern sidoperator optr3;
  
  // will only reset if init was successful
  if ( initflag )
  {
	char* poptr1 = (char*)&optr1;
	char* poptr2 = (char*)&optr2;
	char* poptr3 = (char*)&optr3;
	for ( uword i = 0; i < sizeof(sidoperator); i++ )
	{
	  (*(poptr1 +i)) = 0;
	  (*(poptr2 +i)) = 0;
	  (*(poptr3 +i)) = 0;
	}
	
	optr1.MODULATOR = &optr3;
	optr3.CARRIER = &optr1;
	optr1.ADSRCTRL = 0x0c;
	optr1.SIDWAVE = 1;
	
	optr2.MODULATOR = &optr1;
	optr1.CARRIER = &optr2;
	optr2.ADSRCTRL = 0x0c;
	optr2.SIDWAVE = 1;
	
	optr3.MODULATOR = &optr2;
	optr2.CARRIER = &optr3;
	optr3.ADSRCTRL = 0x0c;
	optr3.SIDWAVE = 1;
	
	sidkeys[4] = 0;
	sidkeys[11] = 0;
	sidkeys[18] = 0;
	
	samplesemureset();
	
	tofill = 0;
	
	// ensure that samplebuffer will be divided into
	// correct number of samples
	//  8-bit mono: buflen x = x samples
	//      stereo:          = x/2 samples
	// 16-bit mono: buflen x = x/2 samples
	//      stereo:          = x/4 samples
	bufferscale = 0;
	if ( sidcfg.channels == SIDEMU_STEREO )  bufferscale++;
	if ( sidcfg.bitspersample == SIDEMU_16BIT )  bufferscale++;
	
	extern void* fill8bitmono(void*, udword);
	extern void* fill8bitstereo(void*, udword);
	extern void* fill16bitmono(void*, udword);
	extern void* fill16bitstereo(void*, udword);

	extern void* (*psidemufillfunc)(void*, udword);
	if ( sidcfg.bitspersample == SIDEMU_8BIT )
	{
	  switch( sidcfg.sampleformat )
	  {
	   case SIDEMU_UNSIGNED_PCM:
		zero8bit = 0x80;
		switch( sidcfg.channels )
		{
		 case SIDEMU_MONO:
		  psidemufillfunc = &fill8bitmono;
		  break;
		 case SIDEMU_STEREO:
		  psidemufillfunc = &fill8bitstereo;
		  break;
		}
		break;
	   case SIDEMU_SIGNED_PCM:
		zero8bit = 0;
		switch( sidcfg.channels )
		{
		 case SIDEMU_MONO:
		  psidemufillfunc = &fill8bitmono;
		  break;
		 case SIDEMU_STEREO:
		  psidemufillfunc = &fill8bitstereo;
		  break;
		}
		break;
	  }
  	}
	else if ( sidcfg.bitspersample == SIDEMU_16BIT )
	{
	  switch( sidcfg.sampleformat )
	  {
	   case SIDEMU_UNSIGNED_PCM:
		zero16bit = 0x8000;
		switch( sidcfg.channels )
		{
		 case SIDEMU_MONO:
		  psidemufillfunc = &fill16bitmono;
		  break;
		 case SIDEMU_STEREO:
		  psidemufillfunc = &fill16bitstereo;
		  break;
		}
		break;
	   case SIDEMU_SIGNED_PCM:
		zero16bit = 0;
		switch( sidcfg.channels )
		{
		 case SIDEMU_MONO:
		  psidemufillfunc = &fill16bitmono;
		  break;
		 case SIDEMU_STEREO:
		  psidemufillfunc = &fill16bitstereo;
		  break;
		}
		break;
	  }
	} // end else bitspersample
	// set the emulator status
	return( sidcfg.ready = TRUE);
  }
  else  
	return( sidcfg.ready = FALSE);
}
