/*
 * $Id: 6581.h,v 1.4 1996/02/28 00:31:28 ms Exp $
 *
 *
 * $Log: 6581.h,v $
 * Revision 1.4  1996/02/28 00:31:28  ms
 * *** empty log message ***
 *
 * Revision 1.3  1996/02/18 19:54:08  ms
 * Added stereo for 8 and 16-bit, plus new constants
 *
 * Revision 1.2  1996/02/16 00:58:14  ms
 * Completely changed interface to SIDEMU
 * Needs mos_6581/config.cxx; init.c, reset.cxx are obsolete
 *
 * Revision 1.1  1996/02/09 19:31:48  ms
 * Changes according to changes in mos_6581/6581_.cxx revision 1.1
 *
 * Revision 1.0  1996/01/21 04:11:20  ms
 * Initial revision
 *
 */

#ifndef __6581_H
  #define __6581_H


#include "mytypes.h"

extern "C" void sidsetreplayingspeed(byte, byte);
extern "C" void sidchangereplayingspeed(void);
extern int sidemufreemem();


enum 
{ // sample format and configuration constants
  SIDEMU_UNSIGNED_PCM,
  SIDEMU_SIGNED_PCM,
  SIDEMU_MONO,
  SIDEMU_STEREO
};

const int SIDEMU_8BIT = 8;
const int SIDEMU_16BIT = 16;

class sidtune;


extern "C++" 
{
  class sidemuconfig
  {
	char ready;
	uword frequency;
	uword bitspersample;
	uword sampleformat;
	uword channels;
	uword sidchips;
	
	friend int sidemuinit( sidemuconfig& );
	friend int sidemureset( sidemuconfig& );
	friend void sidemufillbuffer( const sidemuconfig&, 
								  const sidtune&, void*, udword );
	
   public:
	sidemuconfig()
	{
	  ready = FALSE;
	  frequency = 22050;
	  bitspersample = SIDEMU_8BIT;
	  sampleformat = SIDEMU_UNSIGNED_PCM;
	  channels = SIDEMU_MONO;
	  sidchips = 1;
	};
	~sidemuconfig();
	
	uword retfrequency()  { return frequency; }
	uword retbitspersample()  { return bitspersample; }
	uword retsampleformat()  { return sampleformat; }
	uword retchannels()  { return channels; }
	uword retsidchips()  { return sidchips; }
	
	uword setfrequency( uword );
	uword setbitspersample( uword );
	uword setsampleformat( uword );
	uword setchannels( uword );
	uword setsidchips( uword );
  };
} // end extern


#endif
