/*
 * $Id: psid_.cxx,v 1.3 1996/03/25 05:18:41 ms Exp $
 *
 *
 * $Log: psid_.cxx,v $
 * Revision 1.3  1996/03/25 05:18:41  ms
 * Changed buffer length to unsigned long
 *
 * Revision 1.2  1996/02/27 07:34:48  ms
 * No standard output anymore
 * Changes according to creation of class sidtune.cxx
 *
 * Revision 1.1  1996/02/11 15:10:24  ms
 * Changes due to creation and displacements to "fformat_.cxx"
 * Checking input buffer length to reject too short data
 *
 * Revision 1.0  1996/01/21 04:12:50  ms
 * Initial revision
 *
 */

#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <string.h>

#include "mytypes.h"
#include "sidtune.h"
#include "m68k.h"


struct psid_hdr
{
  char id[4];                    // 'PSID'
  ubyte versionhi, versionlo;    // 0x0001 oder 0x0002
  ubyte datahi, datalo;          // 16-bit offset to binary data in file
  ubyte loadhi, loadlo;          // 16-bit C64 address to load file at
  ubyte inithi, initlo;          // 16-bit C64 address of init subroutine
  ubyte playhi, playlo;          // 16-bit C64 address of play subroutine
  ubyte songshi, songslo;        // number of songs
  ubyte starthi, startlo;        // start song (1-256 !!)
  ubyte speedhihi, speedhilo,
        speedlohi, speedlolo;    // 32-bit speed info (0=50 Hz, 1=60 Hz/timer
  char name[32];                 // ASCII-strings, NULL-terminated ?
  char author[32];
  char copyright[32];
  uword flags;                   // only version 0x0002
  udword reserved;               // only version 0x0002
};

const char text_psidformat[] = "PlaySID single-file-format (PSID)";

  
int sidtune::PSID_filesupport( void* buffer, udword datalength )
{
  // must be at least as long as version 1 plus some data 
  if ( datalength < 0x7C )  return(FALSE);
  
  psid_hdr* pheader = (psid_hdr*)buffer;

  if ( (pheader->id[0] != 'P') ||
       (pheader->id[1] != 'S') ||
       (pheader->id[2] != 'I') ||
       (pheader->id[3] != 'D') ||
       ((pheader->versionhi * 256
         + pheader->versionlo) >=3) )  return(FALSE);

  fileoffset = m68k( pheader->datahi, pheader->datalo );
  loadaddr   = m68k( pheader->loadhi, pheader->loadlo );
  initaddr   = m68k( pheader->inithi, pheader->initlo );
  playaddr   = m68k( pheader->playhi, pheader->playlo );
  songs      = m68k( pheader->songshi, pheader->songslo );
  startsong  = m68k( pheader->starthi, pheader->startlo );
  speed      = m68k( pheader->speedhihi, pheader->speedhilo,
                     pheader->speedlohi, pheader->speedlolo );

  musplayer = FALSE;
  
  if ( loadaddr == 0 )
  {
    ubyte* datptr = (ubyte*)pheader;
    loadaddr = m68k( *(datptr+fileoffset+1), *(datptr+fileoffset) );
    fileoffset += 2;
  }
  if ( initaddr == 0 )  
	initaddr = loadaddr;
  if ( startsong == 0 )  
	startsong = 1;

  // correctly terminate the info strings
  pheader->name[31] = 0;
  pheader->author[31] = 0;
  pheader->copyright[31] = 0;

  // copy info strings, so they won't get lost
  strcpy( &infostring[0][0], pheader->name );
  strcpy( &infostring[1][0], pheader->author );
  strcpy( &infostring[2][0], pheader->copyright );
  numberofinfostrings = 3;

  formatstring = text_psidformat;
  return(TRUE);
}
