/*
 * $Id: samples.cxx,v 1.5 1996/04/02 14:10:09 ms Exp $
 *
 *
 * $Log: samples.cxx,v $
 * Revision 1.5  1996/04/02 14:10:09  ms
 * Completely changed/fixed the Galway-Noise emulation
 *
 * Revision 1.4  1996/03/01 16:17:53  ms
 * *** empty log message ***
 *
 * Revision 1.3  1996/03/01 10:27:40  ms
 * *** empty log message ***
 *
 * Revision 1.2  1996/02/20 19:22:30  ms
 * *** empty log message ***
 *
 * Revision 1.1  1996/02/16 01:00:41  ms
 * Moved some arrays from 6581_.cxx
 *
 * Revision 1.0  1996/01/21 04:12:05  ms
 * Initial revision
 *
 */

#include "mytypes.h"
#include "m68k.h"


extern ubyte* c64mem1;
extern ubyte* c64mem2;
extern uword PCMfreq;
extern int irqflag;

enum  {
  FM_NONE,
  FM_GALWAYON,
  FM_GALWAYOFF,
  FM_HUELSON,
  FM_HUELSOFF
};

char ch4_Active;
char ch4_Mode;
ubyte ch4_Counter;
uword ch4_Address;
udword ch4_LoopWait;
udword ch4_NullWait;
uword ch4_SamAddr;
uword ch4_SamLen;
uword ch4_Period_stp;
uword ch4_Period_pnt;
uword ch4_Pos_stp;
uword ch4_Pos_pnt;

byte galwaynoisetab1[16] =
{
  0x80,0x91,0xa2,0xb3,0xc4,0xd5,0xe6,0xf7,
  0x08,0x19,0x2a,0x3b,0x4c,0x5d,0x6e,0x7f
};

byte galwaynoisetab2[64*16];

byte samplevolshift;
uword samplefreq,
      samplestep,   
      samplepnt,
      sampleaddstep,
      sampleaddpnt;

void SID_8BitSampleEmuInit();
byte SID_8BitSampleEmu();
byte SID_8BitNoSample();
void SID_8BitSampleStop();

void GalwayInit();
byte GalwayReturnSample(void);
void GetNextFour(void);
void SelectVolume(void);

byte (*SampleEmuRout)() = &SID_8BitNoSample;


void samplesemureset()
{
  samplefreq = 0;
  ch4_Active = FALSE;
  ch4_Mode = FM_NONE;
  ch4_Pos_stp = 0;
  ch4_Pos_pnt = 0;
}


void samplesemuinit()
{
  int k = 0;
  for ( int i = 0; i < 16; i++ )  {
    int l = 0;
    for ( int j = 0; j < 64; j++ )  {
      galwaynoisetab2[k++] = galwaynoisetab1[l];
      l = (l+i) & 15;
    }
  }
  samplesemureset();
}


byte SID_8BitNoSample()
{
  return(0);
}


void SID_CheckForSampleEmuInit()
{
  if ( irqflag )  {
    switch ( c64mem2[0xd41d] )  {
	  case 0xFF:
	    SID_8BitSampleEmuInit();
	    break;
	  case 0xFE:
	    SID_8BitSampleEmuInit();
	    break;
	  case 0xFD:
	    SID_8BitSampleStop();
	    break;
	  case 0xFC:
	    SID_8BitSampleEmuInit();
	    break;
	  case 0x00:
	    break;
	  default:
	    GalwayInit();
	    break;
    }
  }
}


void SID_8BitSampleEmuInit()
{
  if ( ch4_Active && ( ch4_Mode == FM_GALWAYON ))
    return;
  
  samplevolshift = ( 0 - (byte)c64mem2[0xd41d] ) >> 1;
  SampleEmuRout = &SID_8BitSampleEmu;
  uword tempfreq = m68k( c64mem2[0xd45e], c64mem2[0xd45d] );
  if ( tempfreq == 0 )  {
    samplefreq = 0;
    samplestep = 0;
    samplepnt = 0;
    sampleaddstep = 0;
    sampleaddpnt = 0;
    SampleEmuRout = &SID_8BitNoSample;
  }
  else  { 
    if ( tempfreq < 8 )  tempfreq = 8;
    if ( tempfreq != samplefreq )  {
      samplefreq = tempfreq;
      udword tempmul = 492624 / samplefreq;
      samplestep = tempmul / PCMfreq;
      samplepnt = (( tempmul % PCMfreq ) * 65536 ) / PCMfreq;
      sampleaddstep = 0;
      sampleaddpnt = 0;
    }
  }
  ch4_Active = TRUE;
  ch4_Mode = FM_HUELSON;
}


void SID_8BitSampleStop()
{
  SampleEmuRout = &SID_8BitNoSample;
  c64mem2[0xd41d] = 0xfd;
  ch4_Mode = FM_NONE;
  ch4_Active = FALSE;
}


byte SID_8BitSampleEmu()
{
  uword sampleindex = sampleaddstep 
                      + m68k( c64mem2[0xd41f], c64mem2[0xd41e] )
		      + c64mem2[0xd45f];
  c64mem2[0xd41f] = sampleindex / 256;		      
  c64mem2[0xd41e] = sampleindex % 256;		      
  sampleaddstep = 0;
  if ( sampleindex >= m68k(c64mem2[0xd43e], c64mem2[0xd43d]) )  {
    if ( c64mem2[0xd43f] != 0xFF )  { 
      if ( c64mem2[0xd43f] != 0 )  
		c64mem2[0xd43f]--;
      else  {
        SID_8BitSampleStop();
		return(0);
      }
    }
    c64mem2[0xd41e] = c64mem2[0xd47e];
    c64mem2[0xd41f] = c64mem2[0xd47f];
    sampleindex = m68k( c64mem2[0xd47f], c64mem2[0xd47e] );
    if ( sampleindex >= m68k( c64mem2[0xd43e], c64mem2[0xd43d] ) )  {
      SID_8BitSampleStop();
      return(0);
    }
  }  
  udword temp = (udword)sampleaddpnt;
  temp += (udword)samplepnt;
  sampleaddpnt = temp & 0xffff;
  sampleaddstep += ( samplestep + ( temp > 65535 ));

  byte tempsample;
  if ( c64mem2[0xd47d] == 0 )  {
    tempsample = (( c64mem1[sampleindex] & 0xF0 ) >> 4 )
                 | (( c64mem1[sampleindex] & 0x0F ) << 4 );
  }
  else  
	tempsample = c64mem1[sampleindex];
  tempsample -= 0x80;
  tempsample >>= samplevolshift;
  return(tempsample);
}

  
void GalwayInit()
{
  if ( ch4_Active ) 
	return;
  
  SampleEmuRout = &SID_8BitNoSample;
  
  ch4_Counter = c64mem2[0xd41d];  
  c64mem2[0xd41d] = 0; 
  
  if (( ch4_Address = m68k( c64mem2[0xd41f], c64mem2[0xd41e] )) == 0 )
	return;
  
  if ( c64mem2[0xd43f] == 0 )
	return;
  ch4_LoopWait = c64mem2[0xd43f];
  
  if ( c64mem2[0xd45d] == 0 )
	return;
  ch4_NullWait = c64mem2[0xd45d];
  
  if ( c64mem2[0xd43e] == 0 )
	return;
  ch4_SamAddr = ((uword)c64mem2[0xd43e]) << 6;
  
  if ( c64mem2[0xd43d] == 0 )
	return;
  ch4_SamLen = c64mem2[0xd43d] +1;
  
  ch4_Active = TRUE;
  ch4_Mode = FM_GALWAYON;
  
  //GalwayFourStart:
  ch4_Pos_stp = 0;
  ch4_Pos_pnt = 0;
  //SelectNewVolume();
  GetNextFour();
  ch4_Counter++;
  
  SampleEmuRout = &GalwayReturnSample;
}


byte GalwayReturnSample()
{
  byte tempsample = galwaynoisetab2[ ch4_SamAddr + ( ch4_Pos_stp & 15 )];
  
  udword temp = (udword)ch4_Pos_pnt;
  temp += (udword)ch4_Period_pnt;
  ch4_Pos_pnt = temp & 0xffff;
  ch4_Pos_stp += ( ch4_Period_stp + ( temp > 65535 ));
  
  if ( ch4_Pos_stp >= ch4_SamLen )  {
	ch4_Pos_stp = 0;
	//GalwayFour:
	GetNextFour();
	if ( ch4_Counter == 0xff )  {
	  //GalwayFourEnd:
	  //SelectVolume();
	  ch4_Active = FALSE;
	  ch4_Mode = FM_GALWAYOFF;
	  SampleEmuRout = &SID_8BitNoSample;
	}
  }
  return(tempsample);
}


void GetNextFour()
{
  udword tempmul = c64mem1[ch4_Address + (uword)ch4_Counter]
	               * ch4_LoopWait + ch4_NullWait;
  udword tempdiv; 
  if ( tempmul != 0 )
	tempdiv = 492624 / tempmul;
  else
	tempdiv = 0;
  ch4_Period_stp = tempdiv / PCMfreq;
  ch4_Period_pnt = (( tempdiv % PCMfreq ) * 65536 ) / PCMfreq;
  ch4_Counter--;
}


void SelectVolume()
{
  //(c64mem2[0xd418] & 15) << 2;
}


void SelectNewVolume()
{
  if (( c64mem2[0xd418] & 15 ) < 12 )  {
	//
  }
}
