/*
 * $Id: regeval.cxx,v 1.2 1996/04/02 14:09:31 ms Exp $
 *
 *
 * $Log: regeval.cxx,v $
 * Revision 1.2  1996/04/02 14:09:31  ms
 * *** empty log message ***
 *
 * Revision 1.1  1996/02/09 16:43:12  ms
 * Updated key_on/off detection according to changes
 * in the original ASM sources
 *
 * Revision 1.0  1996/01/21 04:12:05  ms
 * Initial revision
 *
 */

#include "mytypes.h"
#include "m68k.h"
#include "opstruct.h"


extern ubyte* c64mem1;
extern ubyte* c64mem2;

extern ubyte Mvol[16];
extern ptr2sidfunc EnveModeTable[];


void sidemuset(struct sidoperator* pvoice, uword sidindex)
{
  pvoice->SIDFREQ = m68k( c64mem2[sidindex +1], c64mem2[sidindex] );

  pvoice->RECINDEX = 4096 - ( m68k( c64mem2[sidindex +3],
                                    c64mem2[sidindex +2] ) & 0x0FFF );

  ubyte envetemp, newwave, oldwave;

  oldwave = pvoice->SIDCTRL;
  envetemp = pvoice->ADSRCTRL;
  pvoice->SIDCTRL = ( newwave = c64mem2[sidindex +4] );

  if ((( oldwave ^ newwave ) & 0xF0 ) != 0 )  {
	pvoice->FREQCNT = 0; 
	pvoice->MODCNT = 0;
  }
  pvoice->SIDWAVE = (newwave & 0xF8) >> 3;

  if (( newwave & 1 ) ==0 )
  {
    if (( oldwave & 1 ) !=0 )  envetemp = 2;
  } 

  else if ( (( envetemp & 1 ) != 0 ) || (( oldwave & 1 ) == 0 ) )
  {
     envetemp = 0;
     pvoice->FREQCNT = 0;
     pvoice->MODCNT = 0;
  }

  ubyte ADtemp = c64mem2[sidindex +5];
  ubyte SRtemp = c64mem2[sidindex +6];

  if ( pvoice->SIDAD != ADtemp )  envetemp |= 16;
  else if ( pvoice->SIDSR != SRtemp )  envetemp |= 16;
  pvoice->SIDAD = ADtemp;
  pvoice->SIDSR = SRtemp;
  pvoice->ENVSUSVOL = Mvol[SRtemp >> 4];

  pvoice->ADSRSUB = EnveModeTable[envetemp /2];
  pvoice->ADSRCTRL = envetemp & (255-16-1);
}
