/*
 * $Id: freqcalc.cxx,v 1.1 1996/04/02 14:07:27 ms Exp $
 *
 *
 * $Log: freqcalc.cxx,v $
 * Revision 1.1  1996/04/02 14:07:27  ms
 * Changed the initialization of the ring modulation emulator
 *
 * Revision 1.0  1996/01/21 04:12:05  ms
 * Initial revision
 *
 */

#include "mytypes.h"
#include "opstruct.h"

extern udword PCMsid;
extern udword PCMnoisesid;

extern ubyte wavecalcnormal(struct sidoperator*);
extern ubyte wavecalcringmod(struct sidoperator*);


void sidfrequenzcalc(struct sidoperator* pvoice)
{
  if (( pvoice->SIDCTRL & 0x14 ) == 0x14 )  {
    pvoice->SIDWAVEROUT = &wavecalcringmod;

	if ( pvoice->SIDFREQ < 16 )  {
	  pvoice->FREQCNT = 0;
	  pvoice->FREQLEN = 0;
	  pvoice->FREQPNT = 0;
	  pvoice->FREQADDPNT = 0;
	}
	else  {
	  pvoice->FREQLEN = PCMsid / pvoice->SIDFREQ;
	  pvoice->FREQPNT = (( PCMsid % pvoice->SIDFREQ ) * 65536 )
		                / pvoice->SIDFREQ;
	}
 	
    struct sidoperator* pvoice2 = pvoice->MODULATOR;
    if ( pvoice2->SIDFREQ == 0 )  {
      pvoice->MODFREQPNT = 0;
      pvoice->MODFREQLEN = 0;
      pvoice->MODADDPNT = 0;
    }
    else  {
      pvoice->MODFREQLEN = PCMsid / pvoice2->SIDFREQ;
      pvoice->MODFREQPNT = (( PCMsid % pvoice2->SIDFREQ ) * 65536 ) / pvoice2->SIDFREQ;
    }
  }

  else
  {
    pvoice->SIDWAVEROUT = &wavecalcnormal;

    if ( pvoice->SIDFREQ < 16 )
    { 
	  pvoice->FREQCNT = 0;
      pvoice->FREQPNT = 0;
      pvoice->FREQLEN = 0;
      pvoice->NOISEPNT = 0;
      pvoice->NOISESTEP = 0;
      pvoice->NOISEADDPNT = 0;
      pvoice->NOISEADDSTEP = 0;
      pvoice->MODFREQPNT = 0;
      pvoice->MODFREQLEN = 0;
      pvoice->MODADDPNT = 0;
    }
    else 
    {
      pvoice->FREQLEN = PCMsid / pvoice->SIDFREQ;                    
      pvoice->FREQPNT = (( PCMsid % pvoice->SIDFREQ ) * 65536 )
                        / pvoice->SIDFREQ;  
      if (( pvoice->SIDCTRL & 0x80 ) != 0 )
      {
        pvoice->NOISESTEP = pvoice->SIDFREQ / PCMnoisesid;                  
        pvoice->NOISEPNT = (( pvoice->SIDFREQ % PCMnoisesid ) * 65536 )
                         / PCMnoisesid;  
      } 
    }
  }
}
