/*
 * $Id: reset.c,v 1.3 1996/03/27 01:05:40 ms Exp $
 *
 *
 * $Log: reset.c,v $
 * Revision 1.3  1996/03/27 01:05:40  ms
 * *** empty log message ***
 *
 * Revision 1.2  1996/02/27 23:50:13  ms
 * Added the (previously missing) PAL/NTSC switch
 *
 * Revision 1.1  1996/02/18 19:45:11  ms
 * *** empty log message ***
 *
 * Revision 1.0  1996/01/05 15:33:47  ms
 * Initial revision
 *
 */


#include "mytypes.h"

extern ubyte* c64mem1;  
extern ubyte* c64mem2;   	       		

void c64memreset( palntscflag )
int palntscflag;
{
  udword i;
   
  /* defaults: Basic-ROM on, Kernal-ROM on, I/O on */
  c64mem1[1] = 7;

  /* CIA-Timer A $DC04/5 = $4025 PAL, $4295 NTSC */
  if ( palntscflag )
  {
	c64mem2[0xdc04] = 0x95;
	c64mem2[0xdc05] = 0x42;
  }
  else
  {
	c64mem2[0xdc04] = 0x25;
	c64mem2[0xdc05] = 0x40;
  }
  
  /* fake VBI-interrupts that do $D019, BMI ... */
  c64mem2[0xd019] = 0xff;

  /* software vectors */
  /* IRQ to $EA31 */
  c64mem1[0x0314] = 0x31;
  c64mem1[0x0315] = 0xea;
  /* BRK to $FE66 */
  c64mem1[0x0316] = 0x66;
  c64mem1[0x0317] = 0xfe;
  /* NMI to $FE47 */
  c64mem1[0x0318] = 0x47;
  c64mem1[0x0319] = 0xfe;

  /* hardware vectors */ 
  /* NMI to $FE43 */
  c64mem1[0xfffa] = 0x43;
  c64mem1[0xfffb] = 0xfe;
  /* RESET to $FCE2 */
  c64mem1[0xfffc] = 0xe2;
  c64mem1[0xfffd] = 0xfc;
  /* NMI to $FF48 */
  c64mem1[0xfffe] = 0x48;
  c64mem1[0xffff] = 0xff;

  /* clear SID */
  for ( i = 0; i < 0x1d; i++ )  c64mem2[0xd400 +i] = 0;
  /* default Mastervolume */ 
  c64mem2[0xd418] = 0x0f;
}


void c64memclear()      
{ 
  udword i;
  for ( i = 0; i < 65536; i++ )
  {
    c64mem1[i] = 0; 
    c64mem2[i] = 0; 
  }
}
