/*
 * $Id: info_.cxx,v 1.1 1996/03/25 07:37:59 ms Exp $
 *
 *
 * $Log: info_.cxx,v $
 * Revision 1.1  1996/03/25 07:37:59  ms
 * Initial revision
 *
 */

#include <fstream.h>
#include <iostream.h>
#include <iomanip.h>
#include <strstream.h>

#include <ctype.h>
#include <string.h>

#include "mytypes.h"
#include "m68k.h"
#include "fformat.h"
#include "sidtune.h"


const char text_infoformat[] = "Raw plus PlaySID icon tooltype file (INFO)";
const char text_infochunkerror[] = "ERROR: Invalid tooltype information in icon file";


int sidtune::INFO_filesupport( void* databuffer, udword datalength,
							   void* infobuffer, udword infolength ) 
{
  udword infolencp = infolength;
  char* infobufcp = (char*)infobuffer;
  while ( infolencp > 4 )  {
	if (( *infobufcp == 0x00 ) && ( *(infobufcp+1) == 0x00 ) &&
	( *(infobufcp+2) == 0x00 ) && ( *(infobufcp+3) == 0x0C ))  {
 	  if ( INFO_filesupport_grep( databuffer, datalength,
								  infobufcp, infolencp ))  
		return(TRUE);
	}
	infobufcp++;
	infolencp--;
  };
  return(FALSE);
}


int sidtune::INFO_filesupport_grep( void* databuffer, udword datalength,
                                    char* infobuf, udword infobuflength )
{
  int items = 0;
  udword itemlen = m68k( *infobuf, *(infobuf +1), *(infobuf +2), *(infobuf +3));
  if ( infobuflength < ( itemlen +4 ))  
	return(FALSE);
#ifdef __BORLANDC__
  else if ( stricmp( infobuf +4, field_id2 ) != 0 )  
#else
  else if ( strcasecmp( infobuf +4, field_id2 ) != 0 )
#endif
	return(FALSE);
  else  {	
	// no header in data file
	fileoffset = 0;
	// default = No
	musplayer = FALSE;
	numberofinfostrings = 0;
	// see /c:/source/asm/sidplay/inf_.inc
	infobuflength -= 4; 
	infobuf += 4;
	while ( items < 6 )  {
	  infobuflength -= ( itemlen +4 );
	  infobuf += ( itemlen +4 );
	  itemlen = m68k( *infobuf, *(infobuf +1), *(infobuf +2), *(infobuf +3));
	  if ( infobuflength < ( itemlen +4 ))  
		return(FALSE);
	  if ( mystrncasecmp( infobuf +4, field_id3 ) == 0 )  {
		// ADDRESS
		istrstream addrin( infobuf +4 +strlen(field_id3), itemlen -strlen(field_id3) );
		if ( !addrin )  
		  return(FALSE);
		loadaddr = (uword)readhex( addrin );
		if ( !addrin )  
		  return(FALSE);
		initaddr = (uword)readhex( addrin );
		if ( !addrin )  
		  return(FALSE);
		playaddr = (uword)readhex( addrin );
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id4 ) == 0 )  {
		// SONGS
		istrstream numin( infobuf +4 +strlen(field_id4), itemlen -strlen(field_id4) );
		if ( !numin )  
		  return(FALSE);
		songs = (uword)readdec( numin );
		startsong = (uword)readdec( numin );
		if ( startsong == 0 )  
		  startsong++;
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id5 ) == 0 )  {
		// SPEED
		istrstream speedin( infobuf +4 +strlen(field_id5), itemlen -strlen(field_id5) );
		if ( !speedin )  
		  return(FALSE);
		speed = readhex( speedin );
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id6 ) == 0 )  {
		strcpy( &infostring[0][0], infobuf +4 +strlen(field_id6) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id7 ) == 0 )  {
		strcpy( &infostring[1][0], infobuf +4 +strlen(field_id7) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id8 ) == 0 )  {
		strcpy( &infostring[2][0], infobuf +4 +strlen(field_id8) );
		numberofinfostrings++;
		items++;
	  }
	  else if ( mystrncasecmp( infobuf +4, field_id9 ) == 0 )  {
		musplayer = TRUE;
		items++;
	  }
	  else  {
		formatstring = text_infochunkerror;
		return( FALSE );
	  }
	};
	
	if (( loadaddr == 0 ) && ( datalength >= 2 ))  {
	  ubyte* databufcp = (ubyte*)databuffer;
	  loadaddr = m68k( *(databufcp +fileoffset +1), *(databufcp +fileoffset));
	  fileoffset += 2;
	}
	
	if ( initaddr == 0 )  
	  initaddr = loadaddr;
	
	formatstring = text_infoformat;
	return(TRUE);
  }
}
