/*
 * $Id: sidtune.h,v 1.3 1996/04/02 18:22:25 ms Exp $
 *
 *
 * $Log: sidtune.h,v $
 * Revision 1.3  1996/04/02 18:22:25  ms
 * Added public member functions 'returnplaysidflag()' and 'returnforcentsc()'
 * Changed public member functions 'setplaysidflag()' and 'setforcentsc()'
 * to not return the flag anymore
 * Added alternate constructor; can take new filename extensions as
 * parameter to override the default
 * Added member function 'returndatafilelen()'
 * Fixed 'SID_filesupport()' to not modify the specified info buffer
 *
 * Revision 1.2  1996/03/25 07:25:57  ms
 * Changes according to changes in sidtune.cxx
 *
 * Revision 1.1  1996/02/28 00:38:29  ms
 * Initial revision
 *
 */

#ifndef __SIDTUNE_H
 #define __SIDTUNE_H


#include <fstream.h>

#include "mytypes.h"


class sidemuconfig;


extern "C++" 
{
  class sidtune
  {
	char status;
	const char* statusstring;
	char* datafilename;
	streampos datafilelen;
	const char* formatstring;
	const char* speedstring;
	char stdinflag; // TRUE = load input data from cin
	char playsidflag; // TRUE = more PlaySID like interpreter behaviour
    char forcentscflag; // TRUE = force NTSC speed
	
	uword loadaddr, 
	      initaddr, 
	      playaddr, 
	      songs, 
	      startsong,
	      currentsong;
	udword speed;
	int fileoffset; // files with header: offset to real data
	char musplayer; // TRUE = install sidplayer routine
	ubyte songspeed; // speed of current song
    ubyte playramrom;
	
	// holds text info from the format headers etc.
	char infostring[5][32];
	// holds number of used text info lines
    int numberofinfostrings;
	
	// filename extensions to append for various file types
	char* datafileext;
	char* sidfileext;
	char* infofileext;
	
    friend void sidemufillbuffer( const sidemuconfig&, 
								  const sidtune&, void*, udword );
	
   public:
	// to retrieve data from standard input pass in filename "-"
	sidtune( char* filename );
	// if you want to override the default filename extensions use this
	// contructor. please note that is does NOT append the 'datafileext', 
	// if the specified file 'filename' exists and the loader is able to
	// determine its file format
	sidtune( char* filename, 
			 char* datafileext, 
			 char* sidfileext, 
			 char* infofileext );
	~sidtune();
	// determine object's current status (TRUE = okay, FALSE = error)
	// upon error condition use 'returnstatusstring()' to retrieve
	// a descriptive text string
	operator int();
    
    // returns a text string describing the exit-status of the last
    // operation on an object
	const char* returnstatusstring();
    // returns a text string describing the input file format 
	const char* returnformatstring();
    // returns a text string describing the speed setting of the sidtune
	const char* returnspeedstring();
	
    // toggle higher PlaySID compatibility mode
    // does have an effect upon calling 'initializesong()'
    // input: TRUE (plain memory, use only Akku on initialization)
    //        FALSE (default, more powerful, do bank-switching etc. )
	void setplaysidflag( int );
    int returnplaysidflag();
    // toggle force-NTSC mode
    // does have an effect upon calling 'initializesong()'
    // input: TRUE (force every tune to play at 60 Hz)
    //        FALSE (default)
	void setforcentsc( int );
    int returnforcentsc();

    // prepare a song for replay
	int initializesong( int songnumber );
	int returncurrentsong();
	
    // return sidtune information
	int returnnumberofsongs();
	int returnstartsong();
	uword returnloadaddress();
	uword returninitaddress();
	uword returnplayaddress();
	char* returnnameinfo();
	char* returnauthorinfo();
	char* returncopyrightinfo();
	
    // prefered method to retrieve tune info text strings
    // because different formats have different number of
    // descriptive text lines (e.g. PSID=3, MUS=5)
	int returnnumberofinfostrings();
	char* returninfostring( int linenumber );
	
    streampos returndatafilelen();
 
   private:
	void safeconstructor();
	void stdinconstructor();
    void filesconstructor( char* );   
	streampos loadfile( char* datafilename, void* buffer, udword buflen );
    // various file format support 
	int PSID_filesupport( void* buffer, udword buflen );
	int MUS_filesupport( void* buffer, udword buflen );
	void MUS_installplayer();
    int INFO_filesupport( void* databuffer, udword databuflen,
			      		  void* infobuffer, udword infobuflen );
    int INFO_filesupport_grep( void* databuffer, udword databuflen,
			      		       char* infobuffer, udword infobuflen );
    int SID_filesupport( void* databuffer, udword databuflen,
			      		 void* sidbuffer, udword sidbuflen );
    int SID_filesupport_grep( void* databuffer, udword databuflen,
			      		      char* sidbuffer, udword sidbuflen );
  };
} // end extern
	

#endif
