/*
 * $Id: m68k.h,v 1.1 1996/03/25 09:00:52 ms Exp $
 *
 *
 * $Log: m68k.h,v $
 * Revision 1.1  1996/03/25 09:00:52  ms
 * Borland-Compiler compatibility changes
 *
 * Revision 1.0  1996/01/21 04:11:20  ms
 * Initial revision
 *
 */

#ifndef __M68K_H
  #define __M68K_H


#include "mytypes.h"

/* return 16-bit word in big-endian order */
inline uword m68k(ubyte hi, ubyte lo)
{
  return(( (uword)hi << 8 ) + (uword)lo );
}

/* return 32-bit dword in big-endian order */
inline udword m68k(ubyte hihi, ubyte hilo, ubyte hi, ubyte lo)
{
  return(( (udword)hihi << 24 ) + ( (udword)hilo << 16 ) + ( (udword)hi << 8 ) + (udword)lo );
}

/* convert 16-bit word to big-endian order */
inline uword m68kword( uword intelword )
{
  uword hi = intelword >> 8;
  uword lo = intelword & 255;
  return(( lo << 8 ) + hi );
}

/* convert 32-bit dword to big-endian order */
inline udword m68kdword( udword inteldword )
{
  udword hihi = inteldword >> 24;
  udword hilo = inteldword >> 16;
  udword hi = inteldword >> 8;
  udword lo = inteldword & 255;
  return(( lo << 24 ) + ( hi << 16 ) + ( hilo << 8 ) + hihi );
}


#endif
