/*
 * $Id: fformat_.cxx,v 1.3 1996/04/02 21:11:12 ms Exp $
 *
 *
 * $Log: fformat_.cxx,v $
 * Revision 1.3  1996/04/02 21:11:12  ms
 * Fixed parantheses in 'readhex()'; didn't work on all compilers
 *
 * Revision 1.2  1996/03/25 07:23:14  ms
 * Added more general purpose procedures
 *
 * Revision 1.1  1996/02/27 07:26:43  ms
 * Dropped any sidtune/file variables to class sidtune.cxx
 *
 * Revision 1.0  1996/02/11 15:20:00  ms
 * Initial revision
 *
 */

#include <iostream.h>
#include <iomanip.h>
#include <strstream.h>

#include <ctype.h>
#include <string.h>

#include "mytypes.h"
#include "m68k.h"


extern const char* field_id1 = "SIDPLAY INFOFILE";
extern const char* field_id2 = "SID:PLAYSID";
extern const char* field_id3 = "ADDRESS=";
extern const char* field_id4 = "SONGS=";
extern const char* field_id5 = "SPEED=";
extern const char* field_id6 = "NAME=";
extern const char* field_id7 = "AUTHOR=";
extern const char* field_id8 = "COPYRIGHT=";
extern const char* field_id9 = "SIDSONG=YES";


int mystrncasecmp( char* s1, const char* s2 )
{
  char tmp = *(s1 +strlen(s2));
  *(s1 +strlen(s2)) = 0;
#ifdef __BORLANDC__
  int ret = stricmp( s1, s2 );
#else
  int ret = strcasecmp( s1, s2 );
#endif  
  *(s1 +strlen(s2)) = tmp;
  return( ret );
}


udword readhex( istrstream& hexin )
{
  udword hexlong = 0;
  char c;
  do  {
	hexin >> c;
	if (( c != ',') && ( c != 0 ))  {
	  // machine independed to_upper
	  c &= 0xdf;
	  ( c < 0x3a ) ? ( c &= 0x0f ) : ( c -= ( 0x41 - 0x0a ));
	  hexlong <<= 4;
	  hexlong |= (udword)c;
	}
	else  { 
	  if ( c == 0 )
		hexin.putback(c);
	  break;
	}
  }  while ( hexin );
  return( hexlong );
}


udword readdec( istrstream& decin )
{
  udword hexlong = 0;
  char c;
  do  {
	decin >> c;
	if (( c != ',') && ( c != 0 ))  {
	  c &= 0x0f;
	  hexlong *= 10;
	  hexlong |= (udword)c;
	}
	else  { 
	  if ( c == 0 )
		decin.putback(c);
	  break;
	}
  }  while ( decin );
  return( hexlong );
}


char* returnnextline( char* s )
{
  char* nextline = strchr( s, '\n' );
  if ( nextline != 0 )
	nextline++;
  return(nextline);
}


void terminatethisline( char* s )
{
  // make this line to terminated string
  char* endofline = strchr( s, '\n' );
  if ( endofline != 0 )
	*endofline = 0;
  endofline = strchr( s, 0x0d );
  if ( endofline != 0 )
	*endofline = 0;
}
